<?php

// تنظیمات کش
$cacheFile = 'cacjhnhe.txt'; // فایل کش
$cacheTime = 14 * 60; // 63 دقیقه

// بررسی وجود کش معتبر
if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheTime) {
    $response = file_get_contents($cacheFile);
} else {
    // دریافت داده‌ها از API
    $url = "https://fitn1.ir/Api/Ba%20vpn/Bavpn.php";
    $response = file_get_contents($url);

    if ($response === false) {
        die("خطا در دریافت داده از API");
    }

    // ذخیره در کش
    file_put_contents($cacheFile, $response);
}

// تعریف الگوها برای انواع کانفیگ‌ها
$patterns = [
    'vless' => '/(vless:\/\/[^\s]+)/i',
    'vmess' => '/(vmess:\/\/[^\s]+)/i',
    'trojan' => '/(trojan:\/\/[^\s]+)/i',
    'shadowsocks' => '/(ss:\/\/[^\s]+)/i' // ← الگوی Shadowsocks اضافه شد
];

$configs = [];

// استخراج تمام کانفیگ‌ها
foreach ($patterns as $pattern) {
    if (preg_match_all($pattern, $response, $matches)) {
        $configs = array_merge($configs, $matches[0]);
    }
}

// بررسی وجود داده
if (empty($configs)) {
    die("داده‌ای برای نمایش وجود ندارد");
}

// انتخاب تصادفی یک کانفیگ
$config = $configs[array_rand($configs)];

// چاپ خروجی
echo trim($config);

?>